/**
 * DO NOT EDIT THIS FILE.
 * See the following change record for more information,
 * https://www.drupal.org/node/2815083
 * @preserve
 **/

(function ($, Drupal) {
  Drupal.behaviors.sitemapStatus = {
    attach: function attach(context) {
      var $context = $(context);
      $(
        once(
          'sitemap-enabled',
          $context.find('#sitemap-enabled-wrapper input.form-checkbox'),
          context,
        ),
      ).each(function () {
        var $checkbox = $(this);

        var $row = $context
          .find('#' + $checkbox.attr('id').replace(/-enabled$/, '-weight'))
          .closest('tr');

        var $filterSettings = $context.find(
          '#' + $checkbox.attr('id').replace(/-enabled$/, '-settings'),
        );
        var filterSettingsTab = $filterSettings.data('verticalTab');

        $checkbox.on('click.filterUpdate', function () {
          if ($checkbox.is(':checked')) {
            $row.show();
            if (filterSettingsTab) {
              filterSettingsTab.tabShow().updateSummary();
            } else {
              $filterSettings.show();
            }
          } else {
            $row.hide();
            if (filterSettingsTab) {
              filterSettingsTab.tabHide().updateSummary();
            } else {
              $filterSettings.hide();
            }
          }

          Drupal.tableDrag['sitemap-order'].restripeTable();
        });

        if (filterSettingsTab) {
          filterSettingsTab.details.drupalSetSummary(function () {
            return $checkbox.is(':checked')
              ? Drupal.t('Enabled')
              : Drupal.t('Disabled');
          });
        }

        $checkbox.triggerHandler('click.filterUpdate');
      });
    },
  };
})(jQuery, Drupal);
